<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contentwarehouse;

class GoodocParagraphDroppedCap extends \Google\Model
{
  protected $internal_gapi_mappings = [
        "box" => "Box",
        "lettersCount" => "LettersCount",
  ];
  protected $boxType = GoodocBoundingBox::class;
  protected $boxDataType = '';
  public $box;
  /**
   * @var int
   */
  public $lettersCount;

  /**
   * @param GoodocBoundingBox
   */
  public function setBox(GoodocBoundingBox $box)
  {
    $this->box = $box;
  }
  /**
   * @return GoodocBoundingBox
   */
  public function getBox()
  {
    return $this->box;
  }
  /**
   * @param int
   */
  public function setLettersCount($lettersCount)
  {
    $this->lettersCount = $lettersCount;
  }
  /**
   * @return int
   */
  public function getLettersCount()
  {
    return $this->lettersCount;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoodocParagraphDroppedCap::class, 'Google_Service_Contentwarehouse_GoodocParagraphDroppedCap');
