<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contentwarehouse;

class GeostoreExceptionalHoursProto extends \Google\Model
{
  protected $hoursType = GeostoreBusinessHoursProto::class;
  protected $hoursDataType = '';
  public $hours;
  protected $metadataType = GeostoreFieldMetadataProto::class;
  protected $metadataDataType = '';
  public $metadata;
  protected $rangeType = GeostoreTimeIntervalProto::class;
  protected $rangeDataType = '';
  public $range;

  /**
   * @param GeostoreBusinessHoursProto
   */
  public function setHours(GeostoreBusinessHoursProto $hours)
  {
    $this->hours = $hours;
  }
  /**
   * @return GeostoreBusinessHoursProto
   */
  public function getHours()
  {
    return $this->hours;
  }
  /**
   * @param GeostoreFieldMetadataProto
   */
  public function setMetadata(GeostoreFieldMetadataProto $metadata)
  {
    $this->metadata = $metadata;
  }
  /**
   * @return GeostoreFieldMetadataProto
   */
  public function getMetadata()
  {
    return $this->metadata;
  }
  /**
   * @param GeostoreTimeIntervalProto
   */
  public function setRange(GeostoreTimeIntervalProto $range)
  {
    $this->range = $range;
  }
  /**
   * @return GeostoreTimeIntervalProto
   */
  public function getRange()
  {
    return $this->range;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GeostoreExceptionalHoursProto::class, 'Google_Service_Contentwarehouse_GeostoreExceptionalHoursProto');
